local assets=
{
	Asset("ANIM", "anim/exchangerlever.zip"),
	Asset("ANIM", "anim/swap_exchangerlever.zip"),
	Asset("IMAGE", "images/inventoryimages/exchangerlever.tex"),
	Asset("ATLAS", "images/inventoryimages/exchangerlever.xml"),
}

local function onequip(inst, owner)
	owner.AnimState:OverrideSymbol("swap_object", "swap_exchangerlever", "swap_exchangerlever")
	owner.AnimState:Show("ARM_carry")
	owner.AnimState:Hide("ARM_normal")
end

local function onunequip(inst, owner)
	owner.AnimState:Hide("ARM_carry")
	owner.AnimState:Show("ARM_normal")
end


local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    
	inst:AddComponent("equippable")
	inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)
	
    --inst.AnimState:SetBank("manrabbit_tail")
	inst.AnimState:SetBank("exchangerlever")
    inst.AnimState:SetBuild("exchangerlever")
    inst.AnimState:PlayAnimation("idle",true)
    MakeInventoryPhysics(inst)
    
    --inst:AddComponent("stackable")
	--inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM

    inst:AddComponent("inspectable")
    
	MakeSmallBurnable(inst)
    MakeSmallPropagator(inst)
    
	inst:AddComponent("spellcaster")
    inst.components.spellcaster:SetSpellFn(function(inst, target)
		EEmobexchangerNotAus = true
		inst:Remove()
	end)
    inst.components.spellcaster.canuseontargets = true
    inst.components.spellcaster:SetSpellTestFn(function(inst, caster, target)
		return true
	end)
	
	--inst:AddComponent("tradable")    
	--inst.components.tradable.goldvalue = TUNING.GOLD_VALUES.MEAT*2
	
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "exchangerlever"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/exchangerlever.xml"
    inst.components.inventoryitem:GetImage()
    inst.components.inventoryitem:GetAtlas()
    
	
    --inst:AddComponent("edible")
    --inst.components.edible.foodtype = "HORRIBLE"
    

    return inst
end

return 	Prefab( "common/inventory/exchangerlever", fn, assets)

